/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.OptionsDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;

public abstract class UnitInfo
implements Transferable,
Serializable {
    public static final int CACHE_MODE_PROMPT = 0;
    public static final int CACHE_MODE_INHERIT = 1;
    public static final int CACHE_MODE_LOCAL = 2;
    private boolean m_isSelected = false;
    private int m_nID = 0;
    private String m_szName = "";
    private String m_szType = "";
    private String m_szIcon;
    private String m_szCustomField1 = "";
    private String m_szCustomField2 = "";
    private String m_szCustomField3 = "";
    private String m_szBrowserUrl = "";
    private String m_szAddress = "";
    private String m_szComment = "";
    private String m_szDescription = "";
    private String m_szContact = "";
    private String m_szContactPhone = "";
    private transient CollationKey m_ckName;
    private transient CollationKey m_ckType;
    private transient CollationKey m_ckCustomField1;
    private transient CollationKey m_ckCustomField2;
    private transient CollationKey m_ckCustomField3;
    public static final DataFlavor UNIT_INFO_FLAVOR = new DataFlavor(UnitInfo.class, "Unit Information");
    private static final DataFlavor[] m_flavors = new DataFlavor[]{UNIT_INFO_FLAVOR};
    private int m_nCredCacheMode = 1;

    protected UnitInfo(int n, String string, String string2, String string3, String string4) {
        this(n, string, string2, string3, string4, "");
    }

    protected UnitInfo(int n, String string, String string2, String string3, String string4, String string5) {
        this.m_nID = n;
        this.m_szName = string;
        this.m_szType = string2;
        this.m_szIcon = string3;
        this.m_szAddress = string4;
        this.m_szBrowserUrl = string5;
        this.m_szCustomField1 = "";
        this.m_szCustomField2 = "";
        this.m_szCustomField3 = "";
        this.m_szDescription = "";
        this.m_szContact = "";
        this.m_szContactPhone = "";
        this.m_szComment = "";
    }

    public UnitInfo(UnitInfo unitInfo) {
        this.m_nID = unitInfo.m_nID;
        this.m_szName = unitInfo.m_szName;
        this.m_szType = unitInfo.m_szType;
        this.m_szIcon = unitInfo.m_szIcon;
        this.m_szCustomField1 = unitInfo.m_szCustomField1;
        this.m_szCustomField2 = unitInfo.m_szCustomField2;
        this.m_szCustomField3 = unitInfo.m_szCustomField3;
        this.m_szBrowserUrl = unitInfo.m_szBrowserUrl;
        this.m_szAddress = unitInfo.m_szAddress;
        this.m_szComment = unitInfo.m_szComment;
        this.m_szDescription = unitInfo.m_szDescription;
        this.m_szContact = unitInfo.m_szContact;
        this.m_szContactPhone = unitInfo.m_szContactPhone;
        this.m_ckName = unitInfo.m_ckName;
        this.m_ckType = unitInfo.m_ckType;
        this.m_ckCustomField1 = unitInfo.m_ckCustomField1;
        this.m_ckCustomField2 = unitInfo.m_ckCustomField2;
        this.m_ckCustomField3 = unitInfo.m_ckCustomField3;
    }

    protected UnitInfo(UnitInfo unitInfo, String string) {
        this(unitInfo);
        if (this.m_szIcon == null || this.m_szIcon.length() == 0) {
            this.m_szIcon = string;
        }
    }

    public abstract boolean isAppliance();

    public int getID() {
        return this.m_nID;
    }

    public void setID(int n) {
        if (this.m_nID != 0) {
            throw new IllegalStateException("Cannot change the ID# of an existing unit");
        }
        this.m_nID = n;
    }

    public String getName() {
        return this.m_szName;
    }

    public void setName(String string) {
        this.m_szName = string;
    }

    public boolean getSelected() {
        return this.m_isSelected;
    }

    public void setSelected(boolean bl) {
        this.m_isSelected = bl;
    }

    public String getType() {
        return this.m_szType;
    }

    protected void doSetType(String string) {
        this.m_szType = string;
    }

    public String getIcon() {
        if (this.m_szIcon == null || this.m_szIcon.equals("")) {
            return this.getDefaultIcon();
        }
        return this.m_szIcon;
    }

    public void setIcon(String string) {
        this.m_szIcon = string;
    }

    protected abstract String getDefaultIcon();

    public String getAddress() {
        return this.m_szAddress;
    }

    public void setAddress(String string) throws ExceptionRequestFailed {
        this.m_szAddress = string;
    }

    public String getCustomField(int n) throws ExceptionInvalidArgument {
        switch (n) {
            case 1: {
                return this.m_szCustomField1;
            }
            case 2: {
                return this.m_szCustomField2;
            }
            case 3: {
                return this.m_szCustomField3;
            }
        }
        throw new ExceptionInvalidArgument();
    }

    public String getCustomField1() {
        return this.m_szCustomField1;
    }

    public String getCustomField2() {
        return this.m_szCustomField2;
    }

    public String getCustomField3() {
        return this.m_szCustomField3;
    }

    public void setCustomField(int n, String string) throws ExceptionInvalidArgument {
        switch (n) {
            case 1: {
                this.m_szCustomField1 = string;
                return;
            }
            case 2: {
                this.m_szCustomField2 = string;
                return;
            }
            case 3: {
                this.m_szCustomField3 = string;
                return;
            }
        }
        throw new ExceptionInvalidArgument();
    }

    public void setCustomField1(String string) {
        this.m_szCustomField1 = string;
    }

    public void setCustomField2(String string) {
        this.m_szCustomField2 = string;
    }

    public void setCustomField3(String string) {
        this.m_szCustomField3 = string;
    }

    public String getDescription() {
        return this.m_szDescription;
    }

    public void setDescription(String string) {
        this.m_szDescription = string;
    }

    public String getContact() {
        return this.m_szContact;
    }

    public void setContact(String string) {
        this.m_szContact = string;
    }

    public String getContactPhone() {
        return this.m_szContactPhone;
    }

    public void setContactPhone(String string) {
        this.m_szContactPhone = string;
    }

    public String getComment() {
        return this.m_szComment;
    }

    public void setComment(String string) {
        this.m_szComment = string;
    }

    public String getBrowserURL() {
        return this.m_szBrowserUrl;
    }

    public void setBrowserURL(String string) throws ExceptionRequestFailed {
        this.m_szBrowserUrl = string;
    }

    public abstract boolean isPropertySupported(String var1);

    public abstract int getTelnetPort();

    public abstract void setTelnetPort(int var1) throws ExceptionRequestFailed;

    public abstract boolean getUseDefaultTelnet();

    public abstract void setUseDefaultTelnet(boolean var1) throws ExceptionRequestFailed;

    public abstract boolean getUseBuiltinTelnet();

    public abstract void setUseBuiltinTelnet(boolean var1) throws ExceptionRequestFailed;

    public abstract boolean getTelnetLoginWindow();

    public abstract void setTelnetLoginWindow(boolean var1) throws ExceptionRequestFailed;

    public abstract String getTelnetApplicationPath();

    public abstract void setTelnetApplicationPath(String var1) throws ExceptionRequestFailed;

    public abstract String getTelnetCommandLineArgs();

    public abstract void setTelnetCommandLineArgs(String var1) throws ExceptionRequestFailed;

    public abstract boolean getTelnetLaunchCommandWindow();

    public abstract void setTelnetLaunchCommandWindow(boolean var1) throws ExceptionRequestFailed;

    public void createCollationKeys(Collator collator) {
        this.m_ckName = collator.getCollationKey(this.m_szName);
        this.m_ckType = collator.getCollationKey(this.m_szType);
        this.m_ckCustomField1 = collator.getCollationKey(this.m_szCustomField1);
        this.m_ckCustomField2 = collator.getCollationKey(this.m_szCustomField2);
        this.m_ckCustomField3 = collator.getCollationKey(this.m_szCustomField3);
    }

    public CollationKey getNameKey() {
        return this.m_ckName;
    }

    public CollationKey getTypeKey() {
        return this.m_ckType;
    }

    public CollationKey getCustomFieldKey1() {
        return this.m_ckCustomField1;
    }

    public CollationKey getCustomFieldKey2() {
        return this.m_ckCustomField2;
    }

    public CollationKey getCustomFieldKey3() {
        return this.m_ckCustomField3;
    }

    public boolean equals(Object object) {
        if (object instanceof UnitInfo) {
            UnitInfo unitInfo = (UnitInfo)object;
            return this.getID() == unitInfo.getID() && this.getType().equals(unitInfo.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getID() ^ this.getType().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(UNIT_INFO_FLAVOR);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(UNIT_INFO_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return m_flavors;
    }

    public int getCredentialsCacheMode() {
        return this.m_nCredCacheMode;
    }

    public void setCredentialsCacheMode(int n) {
        if (n >= 0 && n <= 2) {
            this.m_nCredCacheMode = n;
        }
    }

    public boolean isCredentialsCached() {
        return this.m_nCredCacheMode > 0;
    }

    public CredPolicy getPolicy() {
        CredPolicy credPolicy = new CredPolicy();
        if (AVWorksBranding.isCacheCredSupported()) {
            if (!this.isAppliance()) {
                int n = this.getCredentialsCacheMode();
                credPolicy.setCacheMode(n);
                credPolicy.setUseCached(n != 0);
            } else {
                boolean bl = false;
                int n = this.getCredentialsCacheMode();
                try {
                    bl = n == 1 ? OptionsDb.getBooleanValue("CREDENTIALS_CACHED") : n != 0;
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)"UnitInfo:getPolicy", (String)"Database request failed!", (Throwable)exceptionRequestFailed);
                }
                catch (ExceptionNoValue exceptionNoValue) {
                    Trace.logError((String)"UnitInfo:getPolicy", (String)"Options db request failed!", (Throwable)exceptionNoValue);
                    bl = true;
                    try {
                        OptionsDb.setValue("CREDENTIALS_CACHED", bl);
                    }
                    catch (Exception exception) {
                        Trace.logError((String)"UnitInfo:getPolicy", (String)"Failed to save CREDENTIALS_CACHED value!", (Throwable)exception);
                    }
                }
                credPolicy.setCacheMode(n);
                credPolicy.setUseCached(bl);
            }
        }
        return credPolicy;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public class CredPolicy {
        private boolean bUseCacheCred = true;
        private int nCredCachedMode = 0;

        public void setUseCached(boolean bl) {
            this.bUseCacheCred = bl;
        }

        public boolean getUseCache() {
            return this.bUseCacheCred;
        }

        public void setCacheMode(int n) {
            this.nCredCachedMode = n;
        }

        public int getCacheMode() {
            return this.nCredCachedMode;
        }
    }
}

