/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.services;

import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.CustomFoldersDb;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.InterfaceAVWorksNMM;
import com.avocent.avworks.services.NmmDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.Sorter;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.util.Vector;

public class UnitsDb {
    private static final String TRACE_CONTEXT = "UnitsDb";

    public static String[] getUniqueApplianceTypes() throws ExceptionRequestFailed {
        Object[] objectArray;
        int n;
        String string = "SELECT DISTINCT TYPE FROM APPLIANCES WHERE TYPE != '' AND AMP = 1;";
        int n2 = DatabaseSession.executeQuery(string);
        Vector<String> vector = new Vector<String>();
        while ((n = (objectArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                String string2 = objectArray.getString("TYPE");
                vector.addElement(string2);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Sorter.sortStringArray((String[])objectArray, true);
        return objectArray;
    }

    public static String[] getUniqueServerTypes() throws ExceptionRequestFailed {
        Object[] objectArray;
        int n;
        String string = "SELECT DISTINCT TYPE FROM SERVERS WHERE TYPE != '';";
        int n2 = DatabaseSession.executeQuery(string);
        Vector<String> vector = new Vector<String>();
        while ((n = (objectArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                String string2 = objectArray.getString("TYPE");
                vector.addElement(string2);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Sorter.sortStringArray((String[])objectArray, true);
        return objectArray;
    }

    public static String[] getUniqueCustomField1Values() throws ExceptionRequestFailed {
        Object[] objectArray;
        int n;
        Object object;
        int n2;
        String string = "SELECT DISTINCT CUSTOM_FIELD1 FROM APPLIANCES WHERE CUSTOM_FIELD1 != '' AND AMP = 1;";
        int n3 = DatabaseSession.executeQuery(string);
        Vector<String> vector = new Vector<String>();
        while ((n2 = (object = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (n = 1; n <= n2; ++n) {
                object.nextRow();
                String string2 = object.getString("CUSTOM_FIELD1");
                vector.addElement(string2);
            }
            if (object.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        string = "SELECT DISTINCT CUSTOM_FIELD1 FROM SERVERS WHERE CUSTOM_FIELD1 != '';";
        n3 = DatabaseSession.executeQuery(string);
        object = new Vector();
        while ((n = (objectArray = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                String string3 = objectArray.getString("CUSTOM_FIELD1");
                ((Vector)object).addElement(string3);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        objectArray = new String[vector.size()];
        Object[] objectArray2 = new String[((Vector)object).size()];
        vector.copyInto(objectArray);
        ((Vector)object).copyInto(objectArray2);
        String[] stringArray = UnitsDb.mergeStringArrays((String[])objectArray, (String[])objectArray2);
        Sorter.sortStringArray(stringArray, true);
        return stringArray;
    }

    public static String[] getUniqueCustomField2Values(String string) throws ExceptionRequestFailed {
        Object[] objectArray;
        int n;
        Object object;
        int n2;
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT DISTINCT CUSTOM_FIELD2 FROM APPLIANCES WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 != '' " + "AND AMP = 1;";
        int n3 = DatabaseSession.executeQuery(string2);
        Vector<String> vector = new Vector<String>();
        while ((n2 = (object = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (n = 1; n <= n2; ++n) {
                object.nextRow();
                String string3 = object.getString("CUSTOM_FIELD2");
                vector.addElement(string3);
            }
            if (object.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        string2 = "SELECT DISTINCT CUSTOM_FIELD2 FROM SERVERS WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 != '';";
        n3 = DatabaseSession.executeQuery(string2);
        object = new Vector();
        while ((n = (objectArray = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                String string4 = objectArray.getString("CUSTOM_FIELD2");
                ((Vector)object).addElement(string4);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        objectArray = new String[vector.size()];
        Object[] objectArray2 = new String[((Vector)object).size()];
        vector.copyInto(objectArray);
        ((Vector)object).copyInto(objectArray2);
        String[] stringArray = UnitsDb.mergeStringArrays((String[])objectArray, (String[])objectArray2);
        Sorter.sortStringArray(stringArray, true);
        return stringArray;
    }

    public static String[] getUniqueCustomField2Values() throws ExceptionRequestFailed {
        Object[] objectArray;
        int n;
        Object object;
        int n2;
        String string = "SELECT DISTINCT CUSTOM_FIELD2 FROM APPLIANCES WHERE CUSTOM_FIELD2 != '' AND AMP = 1;";
        int n3 = DatabaseSession.executeQuery(string);
        Vector<String> vector = new Vector<String>();
        while ((n2 = (object = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (n = 1; n <= n2; ++n) {
                object.nextRow();
                String string2 = object.getString("CUSTOM_FIELD2");
                vector.addElement(string2);
            }
            if (object.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        string = "SELECT DISTINCT CUSTOM_FIELD2 FROM SERVERS WHERE CUSTOM_FIELD2 != '';";
        n3 = DatabaseSession.executeQuery(string);
        object = new Vector();
        while ((n = (objectArray = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                String string3 = objectArray.getString("CUSTOM_FIELD2");
                ((Vector)object).addElement(string3);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        objectArray = new String[vector.size()];
        Object[] objectArray2 = new String[((Vector)object).size()];
        vector.copyInto(objectArray);
        ((Vector)object).copyInto(objectArray2);
        String[] stringArray = UnitsDb.mergeStringArrays((String[])objectArray, (String[])objectArray2);
        Sorter.sortStringArray(stringArray, true);
        return stringArray;
    }

    public static String[] getUniqueCustomField3Values() throws ExceptionRequestFailed {
        Object[] objectArray;
        int n;
        Object object;
        int n2;
        String string = "SELECT DISTINCT CUSTOM_FIELD3 FROM APPLIANCES WHERE CUSTOM_FIELD3 != '' AND AMP = 1;";
        int n3 = DatabaseSession.executeQuery(string);
        Vector<String> vector = new Vector<String>();
        while ((n2 = (object = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (n = 1; n <= n2; ++n) {
                object.nextRow();
                String string2 = object.getString("CUSTOM_FIELD3");
                vector.addElement(string2);
            }
            if (object.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        string = "SELECT DISTINCT CUSTOM_FIELD3 FROM SERVERS WHERE CUSTOM_FIELD3 != '';";
        n3 = DatabaseSession.executeQuery(string);
        object = new Vector();
        while ((n = (objectArray = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                objectArray.nextRow();
                String string3 = objectArray.getString("CUSTOM_FIELD3");
                ((Vector)object).addElement(string3);
            }
            if (objectArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        objectArray = new String[vector.size()];
        Object[] objectArray2 = new String[((Vector)object).size()];
        vector.copyInto(objectArray);
        ((Vector)object).copyInto(objectArray2);
        String[] stringArray = UnitsDb.mergeStringArrays((String[])objectArray, (String[])objectArray2);
        Sorter.sortStringArray(stringArray, true);
        return stringArray;
    }

    public static String[][] getChildFoldersOfParent(String string) throws ExceptionRequestFailed {
        String[][] stringArray;
        int n;
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT NAME,ID FROM CUSTOM_FOLDERS WHERE PARENT_ID = " + string + " " + "ORDER BY UPPER(NAME);";
        int n2 = DatabaseSession.executeQuery(string2);
        Vector<String[]> vector = new Vector<String[]>();
        while ((n = (stringArray = DatabaseSession.getQueryResults(n2, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                stringArray.nextRow();
                String string3 = stringArray.getString("NAME");
                String string4 = stringArray.getInt("ID") + "";
                String[] stringArray2 = new String[]{string3, string4};
                vector.addElement(stringArray2);
            }
            if (stringArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n2);
        stringArray = new String[vector.size()][2];
        for (n = 0; n < vector.size(); ++n) {
            String[] stringArray3 = (String[])vector.elementAt(n);
            stringArray[n][0] = stringArray3[0];
            stringArray[n][1] = stringArray3[1];
        }
        return stringArray;
    }

    public static UnitInfo[] getUnitsInFolder(String string) throws ExceptionRequestFailed {
        UnitInfo[] unitInfoArray;
        int n;
        Object object;
        int n2;
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT * FROM APPLIANCES,APPLIANCE_CUSTOM_FOLDER_MAP WHERE APPLIANCE_ID = ID AND FOLDER_ID = " + string + ";";
        int n3 = DatabaseSession.executeQuery(string2);
        Vector<ApplianceInfo> vector = new Vector<ApplianceInfo>();
        while ((n2 = (object = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (n = 1; n <= n2; ++n) {
                object.nextRow();
                ApplianceInfo applianceInfo = AppliancesDb.createApplianceInfo((DBaseRequestQueryResults)object);
                vector.addElement(applianceInfo);
            }
            if (object.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        string2 = "SELECT * FROM SERVERS,SERVER_CUSTOM_FOLDER_MAP WHERE SERVER_ID = ID AND FOLDER_ID = " + string + ";";
        n3 = DatabaseSession.executeQuery(string2);
        object = new Vector();
        while ((n = (unitInfoArray = DatabaseSession.getQueryResults(n3, 3)).getRowCount()) != 0) {
            for (int i = 1; i <= n; ++i) {
                unitInfoArray.nextRow();
                ServerInfo serverInfo = ServersDb.createServerInfo((DBaseRequestQueryResults)unitInfoArray);
                ((Vector)object).addElement(serverInfo);
            }
            if (unitInfoArray.getRowCount() >= 3) continue;
        }
        DatabaseSession.closeQuery(n3);
        unitInfoArray = new UnitInfo[((Vector)object).size() + vector.size()];
        n = 0;
        while (vector.size() != 0) {
            unitInfoArray[n++] = (ApplianceInfo)vector.remove(0);
        }
        while (((Vector)object).size() != 0) {
            unitInfoArray[n++] = (ServerInfo)((Vector)object).remove(0);
        }
        return unitInfoArray;
    }

    private static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                if (!stringArray2[n].equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.add(stringArray2[n]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static UnitInfo[] getApplianceList(String string) throws ExceptionRequestFailed {
        try {
            UnitInfo[] unitInfoArray;
            ApplianceInfo[] applianceInfoArray;
            if (string == null || string.length() == 0) {
                applianceInfoArray = AppliancesDb.getManagedAppliances();
            } else {
                unitInfoArray = "WHERE TYPE = " + SqlCmd.quote((String)string);
                applianceInfoArray = AppliancesDb.getManagedAppliances((String)unitInfoArray);
            }
            unitInfoArray = new UnitInfo[applianceInfoArray.length];
            for (int i = 0; i < applianceInfoArray.length; ++i) {
                unitInfoArray[i] = applianceInfoArray[i];
            }
            return unitInfoArray;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)"JFrameExplorer:getAppliances", (String)"no appliances in database");
            return new UnitInfo[0];
        }
    }

    public static UnitInfo[] getServerList(String string) throws ExceptionRequestFailed {
        try {
            UnitInfo[] unitInfoArray;
            ServerInfo[] serverInfoArray;
            if (string == null || string.length() == 0) {
                serverInfoArray = ServersDb.getServerList();
            } else {
                unitInfoArray = "WHERE TYPE = " + SqlCmd.quote((String)string);
                serverInfoArray = ServersDb.getServerList((String)unitInfoArray);
            }
            unitInfoArray = new UnitInfo[serverInfoArray.length];
            for (int i = 0; i < serverInfoArray.length; ++i) {
                unitInfoArray[i] = serverInfoArray[i];
            }
            return unitInfoArray;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)"JFrameExplorer:getServers", (String)"no servers in database");
            return new UnitInfo[0];
        }
    }

    public static UnitInfo[] getAllUnits() throws ExceptionRequestFailed {
        ServerInfo[] serverInfoArray;
        ApplianceInfo[] applianceInfoArray;
        try {
            applianceInfoArray = AppliancesDb.getManagedAppliances();
        }
        catch (ExceptionNoValue exceptionNoValue) {
            applianceInfoArray = new ApplianceInfo[]{};
        }
        try {
            serverInfoArray = ServersDb.getServerList();
        }
        catch (ExceptionNoValue exceptionNoValue) {
            serverInfoArray = new ServerInfo[]{};
        }
        UnitInfo[] unitInfoArray = new UnitInfo[applianceInfoArray.length + serverInfoArray.length];
        for (int i = 0; i < applianceInfoArray.length; ++i) {
            unitInfoArray[i] = applianceInfoArray[i];
        }
        for (int i = 0; i < serverInfoArray.length; ++i) {
            unitInfoArray[i++] = serverInfoArray[i];
        }
        return unitInfoArray;
    }

    public static UnitInfo[] getCustomField2Units(String string, String string2) throws ExceptionRequestFailed {
        ServerInfo[] serverInfoArray;
        ApplianceInfo[] applianceInfoArray;
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string3 = "WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2);
        try {
            applianceInfoArray = AppliancesDb.getManagedAppliances(string3);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            applianceInfoArray = new ApplianceInfo[]{};
        }
        try {
            serverInfoArray = ServersDb.getServerList(string3);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            serverInfoArray = new ServerInfo[]{};
        }
        UnitInfo[] unitInfoArray = new UnitInfo[applianceInfoArray.length + serverInfoArray.length];
        for (int i = 0; i < applianceInfoArray.length; ++i) {
            unitInfoArray[i] = applianceInfoArray[i];
        }
        for (int i = 0; i < serverInfoArray.length; ++i) {
            unitInfoArray[i++] = serverInfoArray[i];
        }
        return unitInfoArray;
    }

    public static UnitInfo[] getCustomField1Units(String string) throws ExceptionRequestFailed {
        ServerInfo[] serverInfoArray;
        ApplianceInfo[] applianceInfoArray;
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string);
        try {
            applianceInfoArray = AppliancesDb.getManagedAppliances(string2);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            applianceInfoArray = new ApplianceInfo[]{};
        }
        try {
            serverInfoArray = ServersDb.getServerList(string2);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            serverInfoArray = new ServerInfo[]{};
        }
        UnitInfo[] unitInfoArray = new UnitInfo[applianceInfoArray.length + serverInfoArray.length];
        for (int i = 0; i < applianceInfoArray.length; ++i) {
            unitInfoArray[i] = applianceInfoArray[i];
        }
        for (int i = 0; i < serverInfoArray.length; ++i) {
            unitInfoArray[i++] = serverInfoArray[i];
        }
        return unitInfoArray;
    }

    public static int getApplianceTypeCount() throws ExceptionRequestFailed {
        int n;
        String string = "SELECT DISTINCT TYPE FROM APPLIANCES WHERE TYPE != '' AND AMP = 1;";
        int n2 = DatabaseSession.executeQuery(string);
        int n3 = 0;
        do {
            DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 3);
            n = dBaseRequestQueryResults.getRowCount();
            n3 += n;
        } while (n >= 3);
        DatabaseSession.closeQuery(n2);
        return n3;
    }

    public static int getServerTypeCount() throws ExceptionRequestFailed {
        return UnitsDb.getServerCountForServerType(null);
    }

    public static int getServerCountForServerType(String string) throws ExceptionRequestFailed {
        int n;
        String string2 = string == null || string.length() == 0 ? "SELECT DISTINCT TYPE FROM SERVERS WHERE TYPE != '';" : "SELECT TYPE FROM SERVERS WHERE TYPE = " + SqlCmd.quote((String)string) + ";";
        int n2 = DatabaseSession.executeQuery(string2);
        int n3 = 0;
        do {
            DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n2, 3);
            n = dBaseRequestQueryResults.getRowCount();
            n3 += n;
        } while (n >= 3);
        DatabaseSession.closeQuery(n2);
        return n3;
    }

    public static int deleteServerType(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "UPDATE SERVERS SET TYPE = '' WHERE TYPE = " + SqlCmd.quote((String)string) + ";";
        int n = DatabaseSession.executeUpdate(string2);
        return n;
    }

    public static int getUnitCountForCustomField1Value(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT COUNT(*) FROM APPLIANCES WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND AMP = 1;";
        int n = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        string2 = "SELECT COUNT(*) FROM SERVERS WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + ";";
        n = DatabaseSession.executeQuery(string2);
        dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        return n2 += dBaseRequestQueryResults.getInt(1);
    }

    public static int deleteCustomField1Value(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "UPDATE SERVERS SET CUSTOM_FIELD1 = '' WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + ";";
        int n = DatabaseSession.executeUpdate(string2);
        string2 = "UPDATE APPLIANCES SET CUSTOM_FIELD1 = '' WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + ";";
        return n += DatabaseSession.executeUpdate(string2);
    }

    public static int getUnitCountForCustomField2Value(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string3 = "SELECT COUNT(*) FROM APPLIANCES WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + " " + "AND AMP = 1;";
        int n = DatabaseSession.executeQuery(string3);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        string3 = "SELECT COUNT(*) FROM SERVERS WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + ";";
        n = DatabaseSession.executeQuery(string3);
        dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        return n2 += dBaseRequestQueryResults.getInt(1);
    }

    public static int deleteCustomField2Value(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string3 = "UPDATE SERVERS SET CUSTOM_FIELD1 = '',CUSTOM_FIELD2 = '' WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + ";";
        int n = DatabaseSession.executeUpdate(string3);
        string3 = "UPDATE APPLIANCES SET CUSTOM_FIELD1 = '',CUSTOM_FIELD2 = '' WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + ";";
        return n += DatabaseSession.executeUpdate(string3);
    }

    public static int getUnitCountForFolder(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT COUNT(*) FROM APPLIANCES,APPLIANCE_CUSTOM_FOLDER_MAP WHERE APPLIANCE_ID = ID AND FOLDER_ID = " + string + ";";
        int n = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        int n2 = dBaseRequestQueryResults.getInt(1);
        string2 = "SELECT COUNT(*) FROM SERVERS,SERVER_CUSTOM_FOLDER_MAP WHERE SERVER_ID = ID AND FOLDER_ID = " + string + ";";
        n = DatabaseSession.executeQuery(string2);
        dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        return n2 += dBaseRequestQueryResults.getInt(1);
    }

    public static void deleteFolder(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        int n = Integer.parseInt(string);
        boolean bl = CustomFoldersDb.delete(n, true);
        if (!bl) {
            throw new ExceptionRequestFailed();
        }
    }

    public static void deleteAppliances(UnitInfo[] unitInfoArray, boolean bl) throws ExceptionRequestFailed {
        try {
            for (int i = 0; i < unitInfoArray.length; ++i) {
                UnitInfo unitInfo = unitInfoArray[i];
                if (!unitInfo.isAppliance()) continue;
                InterfaceAVWorksNMM interfaceAVWorksNMM = NmmDb.getNmm(((ApplianceInfo)unitInfo).getNmmID());
                interfaceAVWorksNMM.deleteAppliance(unitInfo.getID(), bl);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"UnitsDb:deleteAppliances", (String)"A failure occurred while deleting appliances", (Throwable)exception);
            throw new ExceptionRequestFailed((Throwable)exception);
        }
    }

    public static void deleteServers(UnitInfo[] unitInfoArray) throws ExceptionRequestFailed {
        if (unitInfoArray == null || unitInfoArray.length == 0) {
            throw new ExceptionRequestFailed();
        }
        Vector<UnitInfo> vector = new Vector<UnitInfo>();
        for (int i = 0; i < unitInfoArray.length; ++i) {
            if (unitInfoArray[i].isAppliance()) continue;
            vector.add(unitInfoArray[i]);
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((UnitInfo)vector.elementAt(i)).getID();
        }
        ServersDb.delete(nArray);
        while (vector.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE INTERFACES SET CONN_ID = 0, CONN_TYPE = 0 WHERE CONN_TYPE = 1 AND CONN_ID IN (");
            int n = 0;
            while (true) {
                UnitInfo unitInfo = (UnitInfo)vector.remove(0);
                stringBuffer.append(unitInfo.getID());
                if (++n >= 25 || vector.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
    }

    public static void deleteUnits(UnitInfo[] unitInfoArray, boolean bl) throws ExceptionRequestFailed {
        Vector<UnitInfo> vector = new Vector<UnitInfo>();
        Vector<UnitInfo> vector2 = new Vector<UnitInfo>();
        for (int i = 0; i < unitInfoArray.length; ++i) {
            if (unitInfoArray[i].isAppliance()) {
                vector.add(unitInfoArray[i]);
                continue;
            }
            vector2.add(unitInfoArray[i]);
        }
        if (vector2.size() != 0) {
            Object[] objectArray = new UnitInfo[vector2.size()];
            vector2.copyInto(objectArray);
            UnitsDb.deleteServers((UnitInfo[])objectArray);
            AVWorksEventBroadcaster.appendDeletedServers((UnitInfo[])objectArray);
        }
        if (vector.size() != 0) {
            Object[] objectArray = new UnitInfo[vector.size()];
            vector.copyInto(objectArray);
            UnitsDb.deleteAppliances((UnitInfo[])objectArray, bl);
            AVWorksEventBroadcaster.appendDeletedAppliances((UnitInfo[])objectArray);
        }
    }

    public static void setCustomField1(UnitInfo[] unitInfoArray, String string) throws ExceptionRequestFailed {
        int n;
        if (unitInfoArray == null || unitInfoArray.length == 0 || string == null) {
            throw new ExceptionRequestFailed();
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < unitInfoArray.length; ++i) {
            unitInfoArray[i].setCustomField1(string);
            if (unitInfoArray[i].isAppliance()) {
                vector2.add(Integer.toString(unitInfoArray[i].getID()));
                continue;
            }
            vector.add(Integer.toString(unitInfoArray[i].getID()));
        }
        while (vector.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE SERVERS SET CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "WHERE ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector.remove(0));
                if (++n >= 25 || vector.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
        while (vector2.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE APPLIANCES SET CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "WHERE ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector2.remove(0));
                if (++n >= 25 || vector2.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
    }

    public static void setCustomField1AndCustomField2(UnitInfo[] unitInfoArray, String string, String string2) throws ExceptionRequestFailed {
        int n;
        if (unitInfoArray == null || unitInfoArray.length == 0 || string == null || string2 == null) {
            throw new ExceptionRequestFailed();
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < unitInfoArray.length; ++i) {
            unitInfoArray[i].setCustomField1(string);
            unitInfoArray[i].setCustomField2(string2);
            if (unitInfoArray[i].isAppliance()) {
                vector2.add(Integer.toString(unitInfoArray[i].getID()));
                continue;
            }
            vector.add(Integer.toString(unitInfoArray[i].getID()));
        }
        while (vector.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE SERVERS SET CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + "," + "CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + " " + "WHERE ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector.remove(0));
                if (++n >= 25 || vector.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
        while (vector2.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE APPLIANCES SET CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + "," + "CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + " " + "WHERE ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector2.remove(0));
                if (++n >= 25 || vector2.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
    }

    public static void setCustomField3(UnitInfo[] unitInfoArray, String string) throws ExceptionRequestFailed {
        int n;
        if (unitInfoArray == null || unitInfoArray.length == 0 || string == null) {
            throw new ExceptionRequestFailed();
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < unitInfoArray.length; ++i) {
            unitInfoArray[i].setCustomField3(string);
            if (unitInfoArray[i].isAppliance()) {
                vector2.add(Integer.toString(unitInfoArray[i].getID()));
                continue;
            }
            vector.add(Integer.toString(unitInfoArray[i].getID()));
        }
        while (vector.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE SERVERS SET CUSTOM_FIELD3 = " + SqlCmd.quote((String)string) + " " + "WHERE ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector.remove(0));
                if (++n >= 25 || vector.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
        while (vector2.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE APPLIANCES SET CUSTOM_FIELD3 = " + SqlCmd.quote((String)string) + " " + "WHERE ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector2.remove(0));
                if (++n >= 25 || vector2.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
    }

    public static void removeFromFolder(UnitInfo[] unitInfoArray, String string) throws ExceptionRequestFailed {
        int n;
        if (unitInfoArray == null || unitInfoArray.length == 0 || string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < unitInfoArray.length; ++i) {
            if (unitInfoArray[i].isAppliance()) {
                vector2.add(Integer.toString(unitInfoArray[i].getID()));
                continue;
            }
            vector.add(Integer.toString(unitInfoArray[i].getID()));
        }
        while (vector.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM SERVER_CUSTOM_FOLDER_MAP WHERE (FOLDER_ID=" + string + ") " + "AND SERVER_ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector.remove(0));
                if (++n >= 25 || vector.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
        while (vector2.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM APPLIANCE_CUSTOM_FOLDER_MAP WHERE (FOLDER_ID=" + string + ") " + "AND APPLIANCE_ID IN (");
            n = 0;
            while (true) {
                stringBuffer.append((String)vector2.remove(0));
                if (++n >= 25 || vector2.size() == 0) break;
                stringBuffer.append(", ");
            }
            stringBuffer.append(");");
            DatabaseSession.executeUpdate(stringBuffer.toString());
        }
    }

    public static void renameServerType(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string3 = "UPDATE SERVERS SET TYPE = " + SqlCmd.quote((String)string2) + " " + "WHERE TYPE = " + SqlCmd.quote((String)string) + ";";
        DatabaseSession.executeUpdate(string3);
    }

    public static void renameCustomField1(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string3 = "UPDATE SERVERS SET CUSTOM_FIELD1 = " + SqlCmd.quote((String)string2) + " " + "WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + ";";
        DatabaseSession.executeUpdate(string3);
        string3 = "UPDATE APPLIANCES SET CUSTOM_FIELD1 = " + SqlCmd.quote((String)string2) + " " + "WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + ";";
        DatabaseSession.executeUpdate(string3);
    }

    public static void renameCustomField2(String string, String string2, String string3) throws ExceptionRequestFailed {
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string4 = "UPDATE SERVERS SET CUSTOM_FIELD2 = " + SqlCmd.quote((String)string3) + " " + "WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + ";";
        DatabaseSession.executeUpdate(string4);
        string4 = "UPDATE APPLIANCES SET CUSTOM_FIELD2 = " + SqlCmd.quote((String)string3) + " " + "WHERE CUSTOM_FIELD1 = " + SqlCmd.quote((String)string) + " " + "AND CUSTOM_FIELD2 = " + SqlCmd.quote((String)string2) + ";";
        DatabaseSession.executeUpdate(string4);
    }

    public static void renameFolder(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string3 = "UPDATE CUSTOM_FOLDERS SET NAME = " + SqlCmd.quote((String)string2) + " " + "WHERE ID = " + string + ";";
        DatabaseSession.executeUpdate(string3);
    }

    public static String getParentFolder(String string) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0) {
            throw new ExceptionRequestFailed();
        }
        String string2 = "SELECT PARENT_ID FROM CUSTOM_FOLDERS WHERE ID = " + string + ";";
        int n = DatabaseSession.executeQuery(string2);
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults(n, 1);
        DatabaseSession.closeQuery(n);
        if (dBaseRequestQueryResults.getRowCount() != 1) {
            throw new ExceptionRequestFailed();
        }
        dBaseRequestQueryResults.nextRow();
        String string3 = dBaseRequestQueryResults.getString(1);
        return string3;
    }

    public static String getUnitName(int n, String string) throws ExceptionRequestFailed {
        String string2;
        block4: {
            string2 = null;
            try {
                if (string.equals("Appliance")) {
                    ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo(n);
                    string2 = applianceInfo.getName();
                    break block4;
                }
                if (string.equals("Device")) {
                    ServerInfo serverInfo = ServersDb.getServerInfo(n);
                    string2 = serverInfo.getName();
                    break block4;
                }
                Trace.logError((String)TRACE_CONTEXT, (String)("Invalid Unit Type " + string));
                throw new ExceptionRequestFailed("Invalid Unit Type");
            }
            catch (ExceptionNoValue exceptionNoValue) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Unable to get Unit Information", (Throwable)exceptionNoValue);
                throw new ExceptionRequestFailed((Throwable)exceptionNoValue);
            }
        }
        return string2;
    }
}

