/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.ia.customcode;

import com.avocent.ia.customcode.Version;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class CheckWebVersion
extends CustomCodeAction {
    private static final String THIS_VERSION_VAR = "$FULL_VERSION$";
    private static final String WEBUPDATE_VERSION_VAR = "$WEBUPDATE_VERSION$";
    private static final String UPDATE_AVAIL_VAR = "$UPDATE_AVAIL$";
    private static final String CHECK_WEB_ERROR_VAR = "$CHECK_WEB_ERROR$";
    private static final int GREATER = 1;
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int ERROR_CODES_BEGIN = 99;
    private static final int ERROR_THIS_MAJOR = 100;
    private static final int ERROR_THAT_MAJOR = 101;
    private static final int ERROR_THIS_MINOR = 102;
    private static final int ERROR_THAT_MINOR = 103;
    private static final int ERROR_THIS_RELEASE_SYMBOL = 104;
    private static final int ERROR_THAT_RELEASE_SYMBOL = 105;
    private static final int ERROR_THIS_RELEASE_FORMAT = 112;
    private static final int ERROR_THAT_RELEASE_FORMAT = 113;
    private static final int ERROR_THIS_BUILD = 114;
    private static final int ERROR_THAT_BUILD = 115;
    private static final int ERROR_NULL_THIS_VERSION_STRING = 116;
    private static final int ERROR_NULL_THAT_VERSION_STRING = 117;
    private static final int ERROR_THIS_VERSION_FORMAT = 118;
    private static final int ERROR_THAT_VERSION_FORMAT = 119;

    public void install(InstallerProxy ip) throws InstallException {
        try {
            String webUpdateVersion;
            String fullVersion = ip.substitute(THIS_VERSION_VAR);
            String urlName = "ftp://ftp.avocent.com/public/product-upgrades/AutoView1000_2000R/AVWorks/version.txt";
            URL url = new URL(urlName);
            InputStream uin = url.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(uin));
            while ((webUpdateVersion = in.readLine()) != null) {
                ip.setVariable(WEBUPDATE_VERSION_VAR, webUpdateVersion);
                if (fullVersion != null && webUpdateVersion != null) {
                    Version thisVersion = new Version(fullVersion);
                    Version thatVersion = new Version(webUpdateVersion);
                    if (thisVersion.numOfFields() == 4 && thatVersion.numOfFields() == 4) {
                        int errorCode = thisVersion.compareMajorTo(thatVersion);
                        if (errorCode == -1) {
                            ip.setVariable(UPDATE_AVAIL_VAR, "NEWER");
                            return;
                        }
                        if (errorCode == 1) {
                            ip.setVariable(UPDATE_AVAIL_VAR, "OLDER");
                            return;
                        }
                        if (errorCode == 0) {
                            errorCode = thisVersion.compareMinorTo(thatVersion);
                            if (errorCode == -1) {
                                ip.setVariable(UPDATE_AVAIL_VAR, "NEWER");
                                return;
                            }
                            if (errorCode == 1) {
                                ip.setVariable(UPDATE_AVAIL_VAR, "OLDER");
                                return;
                            }
                            if (errorCode == 0) {
                                errorCode = thisVersion.compareReleaseTo(thatVersion);
                                if (errorCode == -1) {
                                    ip.setVariable(UPDATE_AVAIL_VAR, "NEWER");
                                    return;
                                }
                                if (errorCode == 1) {
                                    ip.setVariable(UPDATE_AVAIL_VAR, "OLDER");
                                    return;
                                }
                                if (errorCode == 0) {
                                    errorCode = thisVersion.compareBuildTo(thatVersion);
                                    if (errorCode == -1) {
                                        ip.setVariable(UPDATE_AVAIL_VAR, "NEWER");
                                        return;
                                    }
                                    if (errorCode == 1) {
                                        ip.setVariable(UPDATE_AVAIL_VAR, "OLDER");
                                        return;
                                    }
                                    if (errorCode == 0) {
                                        ip.setVariable(UPDATE_AVAIL_VAR, "SAME");
                                        return;
                                    }
                                    if (errorCode > 99) {
                                        CheckWebVersion.error(errorCode);
                                        ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                                        return;
                                    }
                                }
                                if (errorCode > 99) {
                                    CheckWebVersion.error(errorCode);
                                    ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                                    return;
                                }
                            }
                            if (errorCode > 99) {
                                CheckWebVersion.error(errorCode);
                                ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                                return;
                            }
                        }
                        if (errorCode <= 99) continue;
                        CheckWebVersion.error(errorCode);
                        ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                        return;
                    }
                    if (thisVersion.numOfFields() != 4) {
                        CheckWebVersion.error(118);
                        ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                    }
                    if (thatVersion.numOfFields() != 4) {
                        CheckWebVersion.error(119);
                        ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                    }
                    return;
                }
                if (fullVersion == null) {
                    CheckWebVersion.error(116);
                    ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                }
                if (webUpdateVersion == null) {
                    CheckWebVersion.error(117);
                    ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
                }
                return;
            }
        }
        catch (IOException exception) {
            String msg = exception.toString();
            ip.setVariable(UPDATE_AVAIL_VAR, "WebVersionCompareFailed");
            ip.setVariable(CHECK_WEB_ERROR_VAR, "Error: ".concat(String.valueOf(String.valueOf(msg))));
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return "";
    }

    public String getUninstallStatusMessage() {
        return "";
    }

    public static void error(int errorCode) {
        switch (errorCode) {
            case 100: {
                System.out.println("ERROR: Invalid Major Symbol in 'this' Version");
                break;
            }
            case 101: {
                System.out.println("ERROR: Invalid Major symbol in WebUpdate Version");
                break;
            }
            case 102: {
                System.out.println("ERROR: Invalid Minor Symbol in 'this' Version");
                break;
            }
            case 103: {
                System.out.println("ERROR: Invalid Minor Symbol in WebUpdate Version");
                break;
            }
            case 104: {
                System.out.println("ERROR: Invalid Internal Release Symbol in 'this' Version");
                break;
            }
            case 105: {
                System.out.println("ERROR: Invalid Internal Release Symbol in WebUpdate Version");
                break;
            }
            case 112: {
                System.out.println("ERROR: Invalid Internal Release Format in 'this' Version");
                break;
            }
            case 113: {
                System.out.println("ERROR: Invalid Internal Release Format in WebUpdate Version");
                break;
            }
            case 114: {
                System.out.println("ERROR: Invalid Build Symbol in 'this' Version");
                break;
            }
            case 115: {
                System.out.println("ERROR: Invalid Build Symbol in WebUpdate Version");
                break;
            }
            case 116: {
                System.out.println("ERROR: 'this' Version String = null");
                break;
            }
            case 117: {
                System.out.println("ERROR: WebUpdate Version String = null");
                break;
            }
            case 118: {
                System.out.println("ERROR: Invalid Format in 'this' Version String");
                break;
            }
            case 119: {
                System.out.println("ERROR: Invalid Format in WebUpdate Version String");
            }
        }
    }

    public static void main(String[] args) {
        try {
            String webUpdateVersion;
            String fullVersion = new String("1.2.A.0");
            String urlName = "ftp://ftp.avocent.com/public/product-upgrades/AutoView1000_2000R/AVWorks/version.txt";
            URL url = new URL(urlName);
            InputStream uin = url.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(uin));
            while ((webUpdateVersion = in.readLine()) != null) {
                System.out.println("This Version = ".concat(String.valueOf(String.valueOf(fullVersion))));
                System.out.println("WebUpdate Version = ".concat(String.valueOf(String.valueOf(webUpdateVersion))));
                if (fullVersion != null && webUpdateVersion != null) {
                    Version thisVersion = new Version(fullVersion);
                    Version thatVersion = new Version(webUpdateVersion);
                    if (thisVersion.numOfFields() == 4 && thatVersion.numOfFields() == 4) {
                        int errorCode = thisVersion.compareMajorTo(thatVersion);
                        if (errorCode == -1) {
                            System.out.println("A Newer WebUpdate Version is Available");
                            return;
                        }
                        if (errorCode == 1) {
                            System.out.println("NO WebUpdates Available.");
                            return;
                        }
                        if (errorCode == 0) {
                            errorCode = thisVersion.compareMinorTo(thatVersion);
                            if (errorCode == -1) {
                                System.out.println("A Newer WebUpdate Version is Available");
                                return;
                            }
                            if (errorCode == 1) {
                                System.out.println("No WebUpdates Available");
                                return;
                            }
                            if (errorCode == 0) {
                                errorCode = thisVersion.compareReleaseTo(thatVersion);
                                if (errorCode == -1) {
                                    System.out.println("A Newer WebUpdate Version is Available");
                                    return;
                                }
                                if (errorCode == 1) {
                                    System.out.println("No WebUpdates Available");
                                    return;
                                }
                                if (errorCode == 0) {
                                    errorCode = thisVersion.compareBuildTo(thatVersion);
                                    if (errorCode == -1) {
                                        System.out.println("A Newer WebUpdate Version is Available");
                                        return;
                                    }
                                    if (errorCode == 1) {
                                        System.out.println("No WebUpdates Available");
                                        return;
                                    }
                                    if (errorCode == 0) {
                                        System.out.println("This Version is Current.");
                                        return;
                                    }
                                    if (errorCode > 99) {
                                        CheckWebVersion.error(errorCode);
                                        return;
                                    }
                                }
                                if (errorCode > 99) {
                                    CheckWebVersion.error(errorCode);
                                    return;
                                }
                            }
                            if (errorCode > 99) {
                                CheckWebVersion.error(errorCode);
                                return;
                            }
                        }
                        if (errorCode <= 99) continue;
                        CheckWebVersion.error(errorCode);
                        return;
                    }
                    if (thisVersion.numOfFields() != 4) {
                        CheckWebVersion.error(118);
                    }
                    if (thatVersion.numOfFields() != 4) {
                        CheckWebVersion.error(119);
                    }
                    return;
                }
                if (fullVersion == null) {
                    CheckWebVersion.error(116);
                }
                if (webUpdateVersion == null) {
                    CheckWebVersion.error(117);
                }
                return;
            }
        }
        catch (IOException exception) {
            String msg = exception.toString();
            System.out.println("Error: ".concat(String.valueOf(String.valueOf(msg))));
            System.out.println("Return Error to InstallAnywhere");
        }
    }

    static {
        THIS_VERSION_VAR = THIS_VERSION_VAR;
        WEBUPDATE_VERSION_VAR = WEBUPDATE_VERSION_VAR;
        UPDATE_AVAIL_VAR = UPDATE_AVAIL_VAR;
        CHECK_WEB_ERROR_VAR = CHECK_WEB_ERROR_VAR;
        GREATER = 1;
        LESS = -1;
        EQUAL = 0;
        ERROR_CODES_BEGIN = 99;
        ERROR_THIS_MAJOR = 100;
        ERROR_THAT_MAJOR = 101;
        ERROR_THIS_MINOR = 102;
        ERROR_THAT_MINOR = 103;
        ERROR_THIS_RELEASE_SYMBOL = 104;
        ERROR_THAT_RELEASE_SYMBOL = 105;
        ERROR_THIS_RELEASE_FORMAT = 112;
        ERROR_THAT_RELEASE_FORMAT = 113;
        ERROR_THIS_BUILD = 114;
        ERROR_THAT_BUILD = 115;
        ERROR_NULL_THIS_VERSION_STRING = 116;
        ERROR_NULL_THAT_VERSION_STRING = 117;
        ERROR_THIS_VERSION_FORMAT = 118;
        ERROR_THAT_VERSION_FORMAT = 119;
    }
}

