/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.ia.customcode;

import com.avocent.ia.customcode.Version;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;

public class CompareProductVersionsAction
extends CustomCodeAction {
    private static final String THIS_VERSION_VAR = "$FULL_VERSION$";
    private static final String INSTALLED_VERSION_VAR = "$INSTALLED_VERSION$";
    private static final String VERSION_FOUND_VAR = "$VERSION_FOUND$";
    private static final int GREATER = 1;
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int ERROR_CODES_BEGIN = 99;
    private static final int ERROR_THIS_MAJOR = 100;
    private static final int ERROR_THAT_MAJOR = 101;
    private static final int ERROR_THIS_MINOR = 102;
    private static final int ERROR_THAT_MINOR = 103;
    private static final int ERROR_THIS_RELEASE_SYMBOL = 104;
    private static final int ERROR_THAT_RELEASE_SYMBOL = 105;
    private static final int ERROR_THIS_RELEASE_FORMAT = 112;
    private static final int ERROR_THAT_RELEASE_FORMAT = 113;
    private static final int ERROR_THIS_BUILD = 114;
    private static final int ERROR_THAT_BUILD = 115;
    private static final int ERROR_NULL_THIS_VERSION_STRING = 116;
    private static final int ERROR_NULL_THAT_VERSION_STRING = 117;
    private static final int ERROR_THIS_VERSION_FORMAT = 118;
    private static final int ERROR_THAT_VERSION_FORMAT = 119;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(InstallerProxy ip) throws InstallException {
        String fullVersion = ip.substitute(THIS_VERSION_VAR);
        String installedVersion = ip.substitute(INSTALLED_VERSION_VAR);
        if (fullVersion != null && installedVersion != null) {
            Version thisVersion = new Version(fullVersion);
            Version thatVersion = new Version(installedVersion);
            if (thisVersion.numOfFields() == 4 && thatVersion.numOfFields() == 4) {
                int errorCode = thatVersion.compareMajorTo(thisVersion);
                if (errorCode == 1) {
                    ip.setVariable(VERSION_FOUND_VAR, "NEWER");
                    return;
                }
                if (errorCode == -1) {
                    ip.setVariable(VERSION_FOUND_VAR, "OLDER");
                    return;
                }
                if (errorCode == 0) {
                    errorCode = thatVersion.compareMinorTo(thisVersion);
                    if (errorCode == 1) {
                        ip.setVariable(VERSION_FOUND_VAR, "NEWER");
                        return;
                    }
                    if (errorCode == -1) {
                        ip.setVariable(VERSION_FOUND_VAR, "OLDER");
                        return;
                    }
                    if (errorCode == 0) {
                        errorCode = thatVersion.compareReleaseTo(thisVersion);
                        if (errorCode == 1) {
                            ip.setVariable(VERSION_FOUND_VAR, "NEWER");
                            return;
                        }
                        if (errorCode == -1) {
                            ip.setVariable(VERSION_FOUND_VAR, "OLDER");
                            return;
                        }
                        if (errorCode == 0) {
                            errorCode = thatVersion.compareBuildTo(thisVersion);
                            if (errorCode == 1) {
                                ip.setVariable(VERSION_FOUND_VAR, "NEWER");
                                return;
                            }
                            if (errorCode == -1) {
                                ip.setVariable(VERSION_FOUND_VAR, "OLDER");
                                return;
                            }
                            if (errorCode == 0) {
                                ip.setVariable(VERSION_FOUND_VAR, "SAME");
                                return;
                            }
                            if (errorCode > 99) {
                                CompareProductVersionsAction.error(errorCode);
                                ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
                                return;
                            }
                        }
                        if (errorCode > 99) {
                            CompareProductVersionsAction.error(errorCode);
                            ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
                            return;
                        }
                    }
                    if (errorCode > 99) {
                        CompareProductVersionsAction.error(errorCode);
                        ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
                        return;
                    }
                }
                if (errorCode <= 99) return;
                CompareProductVersionsAction.error(errorCode);
                ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
                return;
            }
            if (thisVersion.numOfFields() != 4) {
                CompareProductVersionsAction.error(118);
                ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
            }
            if (thatVersion.numOfFields() == 4) return;
            CompareProductVersionsAction.error(119);
            ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
            return;
        }
        if (fullVersion == null) {
            CompareProductVersionsAction.error(116);
            ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
        }
        if (installedVersion != null) return;
        CompareProductVersionsAction.error(117);
        ip.setVariable(VERSION_FOUND_VAR, "ProductVersionCompareFailed");
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return "";
    }

    public String getUninstallStatusMessage() {
        return "";
    }

    public static void error(int errorCode) {
        switch (errorCode) {
            case 100: {
                System.out.println("ERROR: Invalid Major Symbol in 'this' Version");
                break;
            }
            case 101: {
                System.out.println("ERROR: Invalid Major symbol in installed Version");
                break;
            }
            case 102: {
                System.out.println("ERROR: Invalid Minor Symbol in 'this' Version");
                break;
            }
            case 103: {
                System.out.println("ERROR: Invalid Minor Symbol in installed Version");
                break;
            }
            case 104: {
                System.out.println("ERROR: Invalid Internal Release Symbol in 'this' Version");
                break;
            }
            case 105: {
                System.out.println("ERROR: Invalid Internal Release Symbol in installed Version");
                break;
            }
            case 112: {
                System.out.println("ERROR: Invalid Internal Release Format in 'this' Version");
                break;
            }
            case 113: {
                System.out.println("ERROR: Invalid Internal Release Format in installed Version");
                break;
            }
            case 114: {
                System.out.println("ERROR: Invalid Build Symbol in 'this' Version");
                break;
            }
            case 115: {
                System.out.println("ERROR: Invalid Build Symbol in installed Version");
                break;
            }
            case 116: {
                System.out.println("ERROR: 'this' Version String = null");
                break;
            }
            case 117: {
                System.out.println("ERROR: Installed Version String = null");
                break;
            }
            case 118: {
                System.out.println("ERROR: Invalid Format in 'this' Version String");
                break;
            }
            case 119: {
                System.out.println("ERROR: Invalid Format in installed Version String");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String fullVersion = new String("1.1.0.0");
        String installedVersion = new String("1.1.1.1");
        if (fullVersion != null && installedVersion != null) {
            Version thisVersion = new Version(fullVersion);
            Version thatVersion = new Version(installedVersion);
            if (thisVersion.numOfFields() == 4 && thatVersion.numOfFields() == 4) {
                int errorCode = thisVersion.compareMajorTo(thatVersion);
                if (errorCode == -1) {
                    System.out.println("Installed Version is NEWER");
                    return;
                }
                if (errorCode == 1) {
                    System.out.println("Installed Version is OLDER");
                    return;
                }
                if (errorCode == 0) {
                    errorCode = thisVersion.compareMinorTo(thatVersion);
                    if (errorCode == -1) {
                        System.out.println("Installed Version is NEWER");
                        return;
                    }
                    if (errorCode == 1) {
                        System.out.println("Installed Version is OLDER");
                        return;
                    }
                    if (errorCode == 0) {
                        errorCode = thisVersion.compareReleaseTo(thatVersion);
                        if (errorCode == -1) {
                            System.out.println("Installed Version is NEWER");
                            return;
                        }
                        if (errorCode == 1) {
                            System.out.println("Installed Version is OLDER");
                            return;
                        }
                        if (errorCode == 0) {
                            errorCode = thisVersion.compareBuildTo(thatVersion);
                            if (errorCode == -1) {
                                System.out.println("Installed Version is NEWER");
                                return;
                            }
                            if (errorCode == 1) {
                                System.out.println("Installed Version is OLDER");
                                return;
                            }
                            if (errorCode == 0) {
                                System.out.println("Installed Version is the SAME");
                                return;
                            }
                            if (errorCode > 99) {
                                CompareProductVersionsAction.error(errorCode);
                                return;
                            }
                        }
                        if (errorCode > 99) {
                            CompareProductVersionsAction.error(errorCode);
                            return;
                        }
                    }
                    if (errorCode > 99) {
                        CompareProductVersionsAction.error(errorCode);
                        return;
                    }
                }
                if (errorCode <= 99) return;
                CompareProductVersionsAction.error(errorCode);
                return;
            }
            if (thisVersion.numOfFields() != 4) {
                CompareProductVersionsAction.error(118);
            }
            if (thatVersion.numOfFields() == 4) return;
            CompareProductVersionsAction.error(119);
            return;
        }
        if (fullVersion == null) {
            CompareProductVersionsAction.error(116);
        }
        if (installedVersion != null) return;
        CompareProductVersionsAction.error(117);
    }

    static {
        THIS_VERSION_VAR = THIS_VERSION_VAR;
        INSTALLED_VERSION_VAR = INSTALLED_VERSION_VAR;
        VERSION_FOUND_VAR = VERSION_FOUND_VAR;
        GREATER = 1;
        LESS = -1;
        EQUAL = 0;
        ERROR_CODES_BEGIN = 99;
        ERROR_THIS_MAJOR = 100;
        ERROR_THAT_MAJOR = 101;
        ERROR_THIS_MINOR = 102;
        ERROR_THAT_MINOR = 103;
        ERROR_THIS_RELEASE_SYMBOL = 104;
        ERROR_THAT_RELEASE_SYMBOL = 105;
        ERROR_THIS_RELEASE_FORMAT = 112;
        ERROR_THAT_RELEASE_FORMAT = 113;
        ERROR_THIS_BUILD = 114;
        ERROR_THAT_BUILD = 115;
        ERROR_NULL_THIS_VERSION_STRING = 116;
        ERROR_NULL_THAT_VERSION_STRING = 117;
        ERROR_THIS_VERSION_FORMAT = 118;
        ERROR_THAT_VERSION_FORMAT = 119;
    }
}

