/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.ia.customcode;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.IOException;
import java.net.Socket;

public class VerifyServiceStart
extends CustomCodeAction {
    private static final String WEBAPPSERVER_PORT = "$HTTPPORT$";
    private static final String SERVICE_STARTED = "$SERVICE_STARTED$";

    public void install(InstallerProxy ip) throws InstallException {
        String webPort = ip.substitute(WEBAPPSERVER_PORT);
        int nInstallPort = Integer.parseInt(webPort);
        boolean bConnected = false;
        long lStart = System.currentTimeMillis();
        while (true) {
            try {
                Socket socket = new Socket("localhost", nInstallPort);
                bConnected = true;
            }
            catch (IOException socket) {
                long lNow;
                if ((lNow = System.currentTimeMillis()) - lStart <= (long)120000) continue;
            }
            break;
        }
        if (bConnected) {
            ip.setVariable(SERVICE_STARTED, "TRUE");
        } else {
            ip.setVariable(SERVICE_STARTED, "FALSE");
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return "";
    }

    public String getUninstallStatusMessage() {
        return "";
    }

    public static void main(String[] args) {
        int nInstallPort = 443;
        boolean bConnected = false;
        long lStart = System.currentTimeMillis();
        while (true) {
            try {
                Socket socket = new Socket("localhost", nInstallPort);
                bConnected = true;
            }
            catch (IOException socket) {
                long lNow;
                if ((lNow = System.currentTimeMillis()) - lStart <= (long)120000) continue;
            }
            break;
        }
        if (bConnected) {
            long lNow = System.currentTimeMillis();
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Service Started in ").append(lNow - lStart).append(" milliseconds"))));
        } else {
            System.out.println("Service did not start");
        }
    }

    static {
        WEBAPPSERVER_PORT = WEBAPPSERVER_PORT;
        SERVICE_STARTED = SERVICE_STARTED;
    }
}

