/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.ia.customcode;

public class Version {
    private String version;
    private String major;
    private String minor;
    private String release;
    private String build;
    private String[] fields;
    private static final int GREATER = 1;
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int DEFAULT = -3;
    private static final int ERROR_THIS_MAJOR = 100;
    private static final int ERROR_THAT_MAJOR = 101;
    private static final int ERROR_THIS_MINOR = 102;
    private static final int ERROR_THAT_MINOR = 103;
    private static final int ERROR_THIS_RELEASE_SYMBOL = 104;
    private static final int ERROR_THAT_RELEASE_SYMBOL = 105;
    private static final int ERROR_THIS_RELEASE_FORMAT = 112;
    private static final int ERROR_THAT_RELEASE_FORMAT = 113;
    private static final int ERROR_THIS_BUILD = 114;
    private static final int ERROR_THAT_BUILD = 115;

    public Version(String v) {
        this.version = v;
        this.fields = this.getSubstrings();
        if (this.fields.length == 4) {
            this.major = this.fields[0];
            this.minor = this.fields[1];
            this.release = this.fields[2];
            this.build = this.fields[3];
        }
    }

    public int numOfFields() {
        return this.fields.length;
    }

    public int compareMajorTo(Version otherVersion) {
        int thatMajor;
        int thisMajor;
        try {
            thisMajor = Integer.parseInt(this.major);
        }
        catch (NumberFormatException nfe) {
            int n = 100;
            return n;
        }
        try {
            thatMajor = Integer.parseInt(otherVersion.major);
        }
        catch (NumberFormatException nfe) {
            int n = 101;
            return n;
        }
        if (thisMajor > thatMajor) {
            return 1;
        }
        if (thisMajor < thatMajor) {
            return -1;
        }
        if (thisMajor == thatMajor) {
            return 0;
        }
        return -3;
    }

    public int compareMinorTo(Version otherVersion) {
        int thatMinor;
        int thisMinor;
        try {
            thisMinor = Integer.parseInt(this.minor);
        }
        catch (NumberFormatException nfe) {
            int n = 102;
            return n;
        }
        try {
            thatMinor = Integer.parseInt(otherVersion.minor);
        }
        catch (NumberFormatException nfe) {
            int n = 103;
            return n;
        }
        if (thisMinor > thatMinor) {
            return 1;
        }
        if (thisMinor < thatMinor) {
            return -1;
        }
        if (thisMinor == thatMinor) {
            return 0;
        }
        return -3;
    }

    public int compareReleaseTo(Version otherVersion) {
        int thatRelease;
        String charSet2;
        int thisRelease;
        try {
            thisRelease = Integer.parseInt(this.release);
        }
        catch (NumberFormatException nfe) {
            if (this.release.length() == 1) {
                charSet2 = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
                thisRelease = charSet2.indexOf(this.release);
                if (thisRelease == -1) {
                    int n = 104;
                    return n;
                }
            }
            int charSet2 = 112;
            return charSet2;
        }
        try {
            thatRelease = Integer.parseInt(otherVersion.release);
        }
        catch (NumberFormatException nfe) {
            if (otherVersion.release.length() == 1) {
                charSet2 = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
                thatRelease = charSet2.indexOf(otherVersion.release);
                if (thatRelease == -1) {
                    int n = 105;
                    return n;
                }
            }
            int n = 113;
            return n;
        }
        if (thisRelease > thatRelease) {
            return 1;
        }
        if (thisRelease < thatRelease) {
            return -1;
        }
        if (thisRelease == thatRelease) {
            return 0;
        }
        return -3;
    }

    public int compareBuildTo(Version otherVersion) {
        int thatBuild;
        int thisBuild;
        try {
            thisBuild = Integer.parseInt(this.build);
        }
        catch (NumberFormatException nfe) {
            int n = 114;
            return n;
        }
        try {
            thatBuild = Integer.parseInt(otherVersion.build);
        }
        catch (NumberFormatException nfe) {
            int n = 115;
            return n;
        }
        if (thisBuild > thatBuild) {
            return 1;
        }
        if (thisBuild < thatBuild) {
            return -1;
        }
        if (thisBuild == thatBuild) {
            return 0;
        }
        return -3;
    }

    public String[] getSubstrings() {
        int count = 0;
        int separator = 46;
        int index = 0;
        do {
            ++count;
            ++index;
        } while ((index = this.version.indexOf(separator, index)) != -1);
        String[] subStr = new String[count];
        index = 0;
        int endIndex = 0;
        for (int i = 0; i < count; ++i) {
            endIndex = this.version.indexOf(separator, index);
            subStr[i] = endIndex == -1 ? this.version.substring(index) : this.version.substring(index, endIndex);
            index = endIndex + 1;
        }
        return subStr;
    }

    static {
        GREATER = 1;
        LESS = -1;
        EQUAL = 0;
        DEFAULT = -3;
        ERROR_THIS_MAJOR = 100;
        ERROR_THAT_MAJOR = 101;
        ERROR_THIS_MINOR = 102;
        ERROR_THAT_MINOR = 103;
        ERROR_THIS_RELEASE_SYMBOL = 104;
        ERROR_THAT_RELEASE_SYMBOL = 105;
        ERROR_THIS_RELEASE_FORMAT = 112;
        ERROR_THAT_RELEASE_FORMAT = 113;
        ERROR_THIS_BUILD = 114;
        ERROR_THAT_BUILD = 115;
    }
}

