/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.customcode.actions;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.NonfatalInstallException;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class ExecuteUninstallCommand
extends CustomCodeAction {
    public void install(InstallerProxy ip) throws InstallException {
        try {
            String executeString = ip.substitute("$COMMAND_TO_EXECUTE$");
            if (executeString.equals("")) {
                System.err.println("ExecuteUninstallCommand: $COMMAND_TO_EXECUTE$ not set!");
            }
            DataOutput da = ip.getLogOutput();
            da.writeUTF(executeString);
        }
        catch (Exception e) {
            System.err.println("ExecuteUninstallCommand: ");
            e.printStackTrace();
            throw new NonfatalInstallException("ExecuteUninstallCommand ERROR");
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
        try {
            DataInput di = up.getLogInput();
            String executeString = di.readUTF();
            final Process p = Runtime.getRuntime().exec(executeString);
            final StringWriter errWriter = new StringWriter();
            final StringWriter outWriter = new StringWriter();
            Thread thread = new Thread(){

                public void run() {
                    InputStream err = p.getErrorStream();
                    try {
                        int c;
                        while ((c = err.read()) >= 0) {
                            errWriter.write(c);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
            };
            Thread thread2 = new Thread(){

                public void run() {
                    InputStream err = p.getInputStream();
                    try {
                        int c;
                        while ((c = err.read()) >= 0) {
                            outWriter.write(c);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
            };
            thread.start();
            thread2.start();
            p.waitFor();
            String stdErr = errWriter.toString();
            String stdOut = outWriter.toString();
            String exitCode = new Integer(p.exitValue()).toString();
            System.out.println("\n****************************************");
            System.out.println("ExecuteUninstallCommand:".concat(String.valueOf(String.valueOf(executeString))));
            System.out.println("\nStdErr Output: ".concat(String.valueOf(String.valueOf(stdErr))));
            System.out.println("\nStdOut Output: ".concat(String.valueOf(String.valueOf(stdOut))));
            System.out.println("\nExit Code: ".concat(String.valueOf(String.valueOf(exitCode))));
            System.out.println("****************************************\n");
        }
        catch (Exception e) {
            System.err.println("ExecuteUninstallCommand: ");
            e.printStackTrace();
        }
    }

    public String getInstallStatusMessage() {
        return "ExecuteUninstallCommand";
    }

    public String getUninstallStatusMessage() {
        return "ExecuteUninstallCommand";
    }
}

