/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.customcode.util.fileutils;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.NonfatalInstallException;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.io.IOException;

public class DeleteDirectory
extends CustomCodeAction {
    private static final String INSTALL_MESSAGE = "Deleting directories";
    private static final String UNINSTALL_MESSAGE = "";
    private static final String ERR_MSG = "DeleteDirectory: no path specified.";
    private static final String SOURCE_VAR_NAME = "$DeleteDirectory_Path$";
    private boolean isLoaded = false;

    public void install(InstallerProxy ip) throws InstallException {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        String path = ip.substitute(SOURCE_VAR_NAME);
        if (path.equals(UNINSTALL_MESSAGE)) {
            this.error(path);
        } else {
            try {
                DeleteDirectory.deleteDirectory(path);
            }
            catch (IOException ioe) {
                throw new NonfatalInstallException(ioe.getMessage());
            }
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return INSTALL_MESSAGE;
    }

    public String getUninstallStatusMessage() {
        return UNINSTALL_MESSAGE;
    }

    public static void deleteDirectory(String directoryToDelete) throws IOException {
        DeleteDirectory.deleteDirectory(new File(directoryToDelete));
    }

    public static boolean deleteDirectory(File directoryToDelete) throws IOException {
        if (directoryToDelete.isDirectory()) {
            String fileSep = System.getProperty("file.separator");
            String[] filesAndDirs = directoryToDelete.list();
            int numberFiles = filesAndDirs.length;
            for (int i = 0; i < numberFiles; ++i) {
                File currentFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(directoryToDelete.getPath()))).append(fileSep).append(filesAndDirs[i]))));
                if (currentFile.isDirectory()) {
                    if (DeleteDirectory.deleteDirectory(currentFile)) continue;
                    return false;
                }
                if (currentFile.delete()) continue;
                System.err.println("DELETING");
                throw new IOException("Can't delete file or directory: ".concat(String.valueOf(String.valueOf(currentFile.getAbsolutePath()))));
            }
            return directoryToDelete.delete();
        }
        throw new IOException("Couldn't delete directory because directory is a file: ".concat(String.valueOf(String.valueOf(directoryToDelete.getAbsolutePath()))));
    }

    private void error(String path) {
        System.err.println(ERR_MSG);
        System.err.println("Path: ".concat(String.valueOf(String.valueOf(path))));
    }

    static {
        INSTALL_MESSAGE = INSTALL_MESSAGE;
        UNINSTALL_MESSAGE = UNINSTALL_MESSAGE;
        ERR_MSG = ERR_MSG;
        SOURCE_VAR_NAME = SOURCE_VAR_NAME;
    }
}

