/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.customcode.util.fileutils;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.NonfatalInstallException;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.io.IOException;

public class DeleteFile
extends CustomCodeAction {
    private static final String INSTALL_MESSAGE = "Removing files";
    private static final String UNINSTALL_MESSAGE = "";
    private static final String ERR_MSG = "DeleteFile: no file specified.";
    private static final String FILE_VAR_NAME = "$DeleteFile_File$";
    private boolean isLoaded = false;

    public void install(InstallerProxy ip) throws InstallException {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        String fileToDelete = ip.substitute(FILE_VAR_NAME);
        if (fileToDelete.equals(UNINSTALL_MESSAGE)) {
            this.error(fileToDelete);
        } else {
            try {
                DeleteFile.deleteFile(fileToDelete);
            }
            catch (IOException ioe) {
                throw new NonfatalInstallException(ioe.getMessage());
            }
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return INSTALL_MESSAGE;
    }

    public String getUninstallStatusMessage() {
        return UNINSTALL_MESSAGE;
    }

    public static void deleteFile(String fileToDelete) throws IOException {
        DeleteFile.deleteFile(new File(fileToDelete));
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        if (fileToDelete.isFile()) {
            if (!fileToDelete.delete()) {
                throw new IOException("Couldn't delete file: ".concat(String.valueOf(String.valueOf(fileToDelete.getAbsolutePath()))));
            }
        } else {
            throw new IOException("Couldn't delete file because file is a directory: ".concat(String.valueOf(String.valueOf(fileToDelete.getAbsolutePath()))));
        }
    }

    private void error(String path) {
        System.err.println(ERR_MSG);
        System.err.println("Path: ".concat(String.valueOf(String.valueOf(path))));
    }

    static {
        INSTALL_MESSAGE = INSTALL_MESSAGE;
        UNINSTALL_MESSAGE = UNINSTALL_MESSAGE;
        ERR_MSG = ERR_MSG;
        FILE_VAR_NAME = FILE_VAR_NAME;
    }
}

