/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.customcode.util.fileutils;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.NonfatalInstallException;
import com.zerog.ia.api.pub.UninstallerProxy;
import com.zerog.ia.customcode.util.fileutils.OtherUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class ExtractToFile
extends CustomCodeAction {
    private static final String INSTALL_MESSAGE = "Extracting files";
    private static final String UNINSTALL_MESSAGE = "";
    private static final String ERR_MSG = "ExtractToFile: no source or destination specified.";
    private static final String SOURCE_VAR_NAME = "$ExtractToFile_Source$";
    private static final String DEST_VAR_NAME = "$ExtractToFile_Destination$";
    private boolean isLoaded = false;

    private static void debugMsg(String msg) {
        System.out.println("ExtractToFile: ".concat(String.valueOf(String.valueOf(msg))));
    }

    public void install(InstallerProxy ip) throws InstallException {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        String source = ip.substitute(SOURCE_VAR_NAME);
        String destination = ip.substitute(DEST_VAR_NAME);
        if (source.equals(UNINSTALL_MESSAGE) || destination.equals(UNINSTALL_MESSAGE)) {
            this.error(source, destination);
        } else {
            try {
                URL sourceURL = ip.getResource(source);
                ExtractToFile.extractResource(sourceURL, destination);
            }
            catch (IOException ioe) {
                throw new NonfatalInstallException(ioe.getMessage());
            }
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return INSTALL_MESSAGE;
    }

    public String getUninstallStatusMessage() {
        return UNINSTALL_MESSAGE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File extractResource(URL extractWhatURL, String target) throws IOException {
        InputStream in;
        File dest;
        block7: {
            dest = new File(target);
            in = null;
            OutputStream out = null;
            try {
                try {
                    ExtractToFile.debugMsg("target = ".concat(String.valueOf(String.valueOf(target))));
                    ExtractToFile.debugMsg("extractWhatURL = ".concat(String.valueOf(String.valueOf(extractWhatURL.toString()))));
                    in = extractWhatURL.openStream();
                    out = new FileOutputStream(dest);
                    OtherUtils.bufStreamCopy(in, out);
                    out.flush();
                    out.close();
                    in.close();
                }
                catch (IOException ioe) {
                    ExtractToFile.debugMsg("Exception caught.");
                    if (out == null) {
                        ExtractToFile.debugMsg("out = null.");
                    }
                    if (in != null) throw new IOException(ioe.getMessage());
                    ExtractToFile.debugMsg("in == null");
                    throw new IOException(ioe.getMessage());
                }
                Object var7_5 = null;
                if (out == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (out != null) {
                    out.flush();
                    out.close();
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            out.flush();
            out.close();
        }
        if (in == null) return dest;
        in.close();
        return dest;
    }

    private void error(String source, String destination) {
        System.err.println(ERR_MSG);
        System.err.println("Source: ".concat(String.valueOf(String.valueOf(source))));
        System.err.println("Destination: ".concat(String.valueOf(String.valueOf(destination))));
    }

    static {
        INSTALL_MESSAGE = INSTALL_MESSAGE;
        UNINSTALL_MESSAGE = UNINSTALL_MESSAGE;
        ERR_MSG = ERR_MSG;
        SOURCE_VAR_NAME = SOURCE_VAR_NAME;
        DEST_VAR_NAME = DEST_VAR_NAME;
    }
}

