/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.customcode.util.fileutils;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.NonfatalInstallException;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.io.IOException;

public class Rename
extends CustomCodeAction {
    private static final String INSTALL_MESSAGE = "Renaming files";
    private static final String UNINSTALL_MESSAGE = "";
    private static final String ERR_MSG = "Rename: no target or new name specified.";
    private static final String TARGET_VAR_NAME = "$Rename_Target$";
    private static final String NEWNAME_VAR_NAME = "$Rename_NewName$";
    private boolean isLoaded = false;

    public void install(InstallerProxy ip) throws InstallException {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        String target = ip.substitute(TARGET_VAR_NAME);
        String newName = ip.substitute(NEWNAME_VAR_NAME);
        if (target.equals(UNINSTALL_MESSAGE) || newName.equals(UNINSTALL_MESSAGE)) {
            this.error(target, newName);
        } else {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("target = ").append(target).append(", newName = ").append(newName))));
            try {
                Rename.rename(target, newName);
            }
            catch (IOException ioe) {
                throw new NonfatalInstallException(ioe.getMessage());
            }
        }
    }

    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public String getInstallStatusMessage() {
        return INSTALL_MESSAGE;
    }

    public String getUninstallStatusMessage() {
        return UNINSTALL_MESSAGE;
    }

    public static void rename(String target, String newName) throws IOException {
        Rename.rename(new File(target), newName);
    }

    public static void rename(File target, String newName) throws IOException {
        if (!target.renameTo(new File(target.getParent(), newName))) {
            throw new IOException("Couldn't rename file.");
        }
    }

    private void error(String target, String newName) {
        System.err.println(ERR_MSG);
        System.err.println("Target: ".concat(String.valueOf(String.valueOf(target))));
        System.err.println("New Name: ".concat(String.valueOf(String.valueOf(newName))));
    }

    static {
        INSTALL_MESSAGE = INSTALL_MESSAGE;
        UNINSTALL_MESSAGE = UNINSTALL_MESSAGE;
        ERR_MSG = ERR_MSG;
        TARGET_VAR_NAME = TARGET_VAR_NAME;
        NEWNAME_VAR_NAME = NEWNAME_VAR_NAME;
    }
}

