/*
 * Copyright (c) 2020, 2022, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package java.lang.foreign;

import jdk.internal.javac.PreviewFeature;

/**
 * An object that may be projected down to a {@linkplain #address() memory address}.
 * Examples of addressable types are {@link MemorySegment}, {@link MemoryAddress} and {@link VaList}.
 * <p>
 * The {@link Addressable} type is used by a {@linkplain Linker linker} to model the types of
 * {@linkplain Linker#downcallHandle(FunctionDescriptor) downcall handle} parameters that must be passed <em>by reference</em>
 * (e.g. memory addresses, variable argument lists and upcall stubs).
 *
 * @since 19
 */
@PreviewFeature(feature=PreviewFeature.Feature.FOREIGN)
public sealed interface Addressable permits MemorySegment, MemoryAddress, VaList {

    /**
     * {@return the {@linkplain MemoryAddress memory address} associated with this addressable}
     */
    MemoryAddress address();
}
