/*
 * Copyright (c) 2021, 2022, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.internal.foreign;

import jdk.internal.vm.annotation.ForceInline;

import java.lang.foreign.MemorySession;

public interface Scoped {
    @ForceInline
    default MemorySessionImpl sessionImpl() {
        return MemorySessionImpl.toSessionImpl(session());
    }
    MemorySession session();
}
