/*
 * Copyright (c) 2004, Oracle and/or its affiliates. All rights reserved.
 * Copyright (c) 2015, Red Hat Inc.
 * Copyright (c) 2021, Huawei Technologies Co., Ltd. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.jvm.hotspot.debugger.proc.riscv64;

import sun.jvm.hotspot.debugger.*;
import sun.jvm.hotspot.debugger.proc.*;

public class ProcRISCV64ThreadFactory implements ProcThreadFactory {
    private ProcDebugger debugger;

    public ProcRISCV64ThreadFactory(ProcDebugger debugger) {
        this.debugger = debugger;
    }

    public ThreadProxy createThreadWrapper(Address threadIdentifierAddr) {
        return new ProcRISCV64Thread(debugger, threadIdentifierAddr);
    }

    public ThreadProxy createThreadWrapper(long id) {
        return new ProcRISCV64Thread(debugger, id);
    }
}
