/*
 * Copyright (c) 2022, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.net;

import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.net.ExtendedSocketOptions.PlatformSocketOptions;


@SuppressWarnings("removal")
class WindowsSocketOptions extends PlatformSocketOptions {

    public WindowsSocketOptions() {
    }

    @Override
    boolean ipDontFragmentSupported() {
        return true;
    }

    @Override
    void setIpDontFragment(int fd, final boolean value) throws SocketException {
        setIpDontFragment0(fd, value);
    }

    @Override
    boolean getIpDontFragment(int fd) throws SocketException {
        return getIpDontFragment0(fd);
    }

    private static native void setIpDontFragment0(int fd, boolean value) throws SocketException;
    private static native boolean getIpDontFragment0(int fd) throws SocketException;

    static {
        if (System.getSecurityManager() == null) {
            System.loadLibrary("extnet");
        } else {
            AccessController.doPrivileged((PrivilegedAction<Void>) () -> {
                System.loadLibrary("extnet");
                return null;
            });
        }
    }
}
